VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cShapeRoundRect"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private WithEvents TopLeft As cControlPoint
Attribute TopLeft.VB_VarHelpID = -1
Private WithEvents BottomDown As cControlPoint
Attribute BottomDown.VB_VarHelpID = -1
Private WithEvents CenterDrag As cControlPoint
Attribute CenterDrag.VB_VarHelpID = -1

Public Sub Init(Controlpoints As cControlPoints, ByVal X As Double, ByVal Y As Double, ByVal Width As Double, ByVal Height As Double)
  Set TopLeft = Controlpoints.Add("TopLeft" & ObjPtr(Me), X, Y, vbGreen, 6)
  Set BottomDown = Controlpoints.Add("BottomDown" & ObjPtr(Me), X + Width, Y + Height, vbGreen, 6)
  Set CenterDrag = Controlpoints.Add("CenterDrag" & ObjPtr(Me), X + Width / 2, Y + Height / 2, vbMagenta, 9)
End Sub

Public Sub Draw(CC As cCairoContext)
  CC.Save
    'as always, we define the path first...
    CC.RoundedRect TopLeft.X, TopLeft.Y, Width, Height, 15
    
    CC.SetSourceColor vbRed, 0.5 '<- note the Alpha-Opacity-Value-Param (normally at default 1 = Full Opacity)
    CC.Fill True '<- note the Optional "True"-param here, meaning we do *not* want to close the path yet...
    
    '...since we plan to draw a Border this time too (with a different Stroke-Color)
    CC.SetSourceColor vbBlue, 0.5
    CC.Stroke '*now* the Path gets closed (no Optional DontClosePath-Param set) - and we ensure thereby a combined Fill+Stroke
  CC.Restore
End Sub

Public Property Get Width() As Double
  Width = BottomDown.X - TopLeft.X
End Property
Public Property Get Height() As Double
  Height = BottomDown.Y - TopLeft.Y
End Property


'Control-Point Movement-Events are received below, and we will act accordingly with the necessary adaptions

Private Sub TopLeft_PositionChanging(NewX As Double, NewY As Double)
  If BottomDown.X - NewX < 30 Then NewX = BottomDown.X - 30 'we restrict the Width to a minimum of 30 pixels
  If BottomDown.Y - NewY < 30 Then NewY = BottomDown.Y - 30 'and the Height too...
  
  CenterDrag.X = NewX + Width / 2 '...and readjust the centerPoint accordingly as well
  CenterDrag.Y = NewY + Height / 2
End Sub
Private Sub BottomDown_PositionChanging(NewX As Double, NewY As Double)
  If NewX - TopLeft.X < 30 Then NewX = TopLeft.X + 30 'we restrict the Width to a minimum of 30 pixels
  If NewY - TopLeft.Y < 30 Then NewY = TopLeft.Y + 30 'and the Height too...
  
  CenterDrag.X = NewX - Width / 2 '...and readjust the centerPoint accordingly as well
  CenterDrag.Y = NewY - Height / 2
End Sub
Private Sub CenterDrag_PositionChanging(NewX As Double, NewY As Double)
Dim W#, H#
  W = Width: H = Height 'we need to buffer the current width and height beforehand, to not mess-up the coord-adaptions below, since Width- and Height are dynamically calculated in Properties
  
  TopLeft.X = NewX - W / 2
  TopLeft.Y = NewY - H / 2
  
  BottomDown.X = NewX + W / 2
  BottomDown.Y = NewY + H / 2
End Sub

